unit Nntpmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, Menus, msmsg, agsocket,
  msmb, msnntp, msMsgCls, IniFiles, agTypes, msUtils;

type
  TNNTPForm = class(TForm)
    Panel1: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    RetrieveHeaders1: TMenuItem;
    RetrieveArticle1: TMenuItem;
    Post1: TMenuItem;
    Cancel1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Setup1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    HeadersButton: TSpeedButton;
    ArticleButton: TSpeedButton;
    PostButton: TSpeedButton;
    SetupButton: TSpeedButton;
    ExitButton: TSpeedButton;
    CancelButton: TSpeedButton;
    Bevel1: TBevel;
    NGEdit: TEdit;
    Panel2: TPanel;
    msNNTP: TmsNNTP;
    msArticle1: TmsArticle;
    Sb0: TPanel;
    Sb2: TPanel;
    Sb1: TPanel;
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SetupButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure msNNTPNextHeaderRetrieved(Sender: TObject; Num: Integer);
    procedure msNNTPPosted(Sender: TObject);
    procedure msNNTPCancel(Sender: TObject);
    procedure msNNTPClosed(Sender: TObject);
    procedure msNNTPOpen(Sender: TObject);
    procedure msNNTPError(Sender: TObject; var Msg: OpenString);
    procedure msNNTPArticleRetrieved(Sender: TObject);
    procedure msNNTPProgress(Sender: TObject; Perc: Integer);
    procedure msNNTPGroupSelected(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure NGEditChange(Sender: TObject);
    procedure HeadersButtonClick(Sender: TObject);
    procedure PostButtonClick(Sender: TObject);
    procedure ArticleButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure msNNTPPosting(Sender: TObject);
    procedure msNNTPLastHeaderRetrieved(Sender: TObject);
  private
    { Private declarations }
    IniFileName : string;
    UserName : string;
    UserAddress : string;
    HdrStep : Integer;
    Encoding : TMsgEncoding;
    CharSet : TCharSet;
    Posting : boolean;
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  NNTPForm: TNNTPForm;

implementation

{$R *.DFM}

uses NNTPSu, msAbout, NNTPPst, PopView;

procedure TNNTPForm.DisableControls;
begin
  HeadersButton.Enabled:=false;
  RetrieveHeaders1.Enabled:=false;
  ArticleButton.Enabled:=false;
  RetrieveArticle1.Enabled:=false;
  PostButton.Enabled:=false;
  Post1.Enabled:=false;
  CancelButton.Enabled:=true;
  Cancel1.Enabled:=true;
  SetupButton.Enabled:=false;
  Setup1.Enabled:=false;
  ExitButton.Enabled:=false;
  Exit1.Enabled:=false;
  Help1.Enabled:=false;
  ListBox1.Cursor:=crHourGlass;
  NGEdit.Enabled:=false;
end;

procedure TNNTPForm.EnableControls;
begin
  HeadersButton.Enabled:=true;
  RetrieveHeaders1.Enabled:=true;
  ArticleButton.Enabled:=true;
  RetrieveArticle1.Enabled:=true;
  PostButton.Enabled:=true;
  Post1.Enabled:=true;
  CancelButton.Enabled:=false;
  Cancel1.Enabled:=true;
  SetupButton.Enabled:=true;
  Setup1.Enabled:=true;
  ExitButton.Enabled:=true;
  Exit1.Enabled:=true;
  Help1.Enabled:=true;
  NGEdit.Enabled:=true;
  ListBox1.Cursor:=crDefault;
end;

procedure TNNTPForm.FormCreate(Sender: TObject);
begin
  IniFileName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniFileName) do
  try
    msNNTP.Server:=ReadString('Setup','Server','');
    UserAddress:=ReadString('Setup','EMail Address','');
    UserName:=ReadString('Setup','Name','');
    msNNTP.LogFileName:=ReadString('Setup','Log File','');
    CharSet:=TCharSet(ReadInteger('Setup','CharSet',0));
    Encoding:=TMsgEncoding(ReadInteger('Setup','Encoding',0));
    HdrStep:=ReadInteger('Setup','Header Step',50);
  finally
    Free;
  end;
  Posting:=false;
end;

procedure TNNTPForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  msNNTP.CloseConnection;
  with TIniFile.Create(IniFileName) do
  try
    WriteString('Setup','Server',msNNTP.Server);
    WriteString('Setup','EMail Address',UserAddress);
    WriteString('Setup','Name',UserName);
    WriteString('Setup','Log File',msNNTP.LogFileName);
    WriteInteger('Setup','CharSet',Ord(CharSet));
    WriteInteger('Setup','Encoding',Ord(Encoding));
    WriteInteger('Setup','Header Step',HdrStep);
  finally
    Free;
  end;
end;

procedure TNNTPForm.SetupButtonClick(Sender: TObject);
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=msNNTP.Server;
    UserAddressEdit.Text:=UserAddress;
    UserNameEdit.Text:=UserName;
    EncodingComboBox.ItemIndex:=Ord(Encoding);
    CharSetComboBox.ItemIndex:=Ord(CharSet);
    LogFileNameEdit.Text:=msNNTP.LogFileName;
    HdrStepEdit.Text:=IntToStr(HdrStep);
    if ShowModal=mrOk then
    begin
      msNNTP.Server:=ServerEdit.Text;
      UserAddress:=UserAddressEdit.Text;
      UserName:=UserNameEdit.Text;
      Encoding:=TMsgEncoding(EncodingComboBox.ItemIndex);
      CharSet:=TCharSet(CharSetComboBox.ItemIndex);
      msNNTP.LogFileName:=LogFileNameEdit.Text;
      try
        HdrStep:=StrToInt(Trim(HdrStepEdit.Text));
      except
        on EConvertError do
          HdrStep:=50
        else raise;
      end;
    end;
  finally
    Free;
  end;
end;

procedure TNNTPForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TNNTPForm.msNNTPNextHeaderRetrieved(Sender: TObject;
  Num: Integer);
begin
  ListBox1.Items.Add(msNNTP.NewsHeadersList[Num].GetFieldBody('Subject'));
  Sb1.Caption:='Headers retrieved '+IntToStr(Num+1);
end;

procedure TNNTPForm.msNNTPPosted(Sender: TObject);
begin
  Sb1.Caption:='Article has been succesfully posted';
end;

procedure TNNTPForm.msNNTPCancel(Sender: TObject);
begin
  Sb1.Caption:='Oparation has been canceled';
end;

procedure TNNTPForm.msNNTPClosed(Sender: TObject);
begin
  Sb1.Caption:='Connection closed';
end;

procedure TNNTPForm.msNNTPOpen(Sender: TObject);
begin
  Sb1.Caption:='Opening connection';
end;

procedure TNNTPForm.msNNTPError(Sender: TObject; var Msg: OpenString);
begin
  Sb1.Caption:=Msg;
end;

procedure TNNTPForm.msNNTPArticleRetrieved(Sender: TObject);
begin
  Sb1.Caption:='Article retrieved';
end;

procedure TNNTPForm.msNNTPProgress(Sender: TObject; Perc: Integer);
begin
  if not Posting then
    SB1.Caption:=IntToStr(Perc)+'% retrieved';
end;

procedure TNNTPForm.msNNTPGroupSelected(Sender: TObject);
begin
  Sb0.Caption:='Total articles: '+IntToStr(msNNTP.TotalArticles);
  Sb2.Caption:=msNNTP.NewsGroup;
end;

procedure TNNTPForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='msNNTP Component Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TNNTPForm.NGEditChange(Sender: TObject);
begin
  if msNNTP.NewsHeadersList.Count>0 then
  begin
    msNNTP.NewsHeadersList.Clear;
    ListBox1.Items.Clear;
  end;
end;

procedure TNNTPForm.HeadersButtonClick(Sender: TObject);
begin
  DisableControls;
  try
    msNNTP.NewsGroup:=NGEdit.Text;
    msNNTP.RetrieveNextNHeaders(HdrStep,true);
  finally
    EnableControls;
  end;
end;

procedure TNNTPForm.PostButtonClick(Sender: TObject);
var
  i : Integer;
begin
  with TArticleForm.Create(Self) do
  try
    NewsGroupsEdit.Text:=NGEdit.Text;
    if ShowModal=mrOK then
    begin
      msArticle1.Clear;
      msArticle1.Sender.Address:=UserAddress;
      msArticle1.Sender.Name:=UserName;
      msArticle1.NewsGroups:=NewsGroupsEdit.Text;
      msArticle1.Subject:=SubjectEdit.Text;
      msArticle1.Encoding:=Encoding;
      msArticle1.CharSet:=CharSet;
      for i:=0 to AttComboBox.Items.Count-1 do
        msArticle1.Attachments.AddFile(AttComboBox.Items[i]);
      msArticle1.Body:=BodyMemo.Lines;
      DisableControls;
      try
        Posting:=true;
        msNNTP.PostArticle;
      finally
        Posting:=false;
        EnableControls;
      end;
    end;
  finally
    Free;
  end;
end;

procedure TNNTPForm.ArticleButtonClick(Sender: TObject);
begin
  if ListBox1.ItemIndex<>-1 then
  begin
    DisableControls;
    try
      msNNTP.RetrieveArticleByNumber(msNNTP.NewsHeadersList[ListBox1.ItemIndex].Number);
    finally
      EnableControls;
    end;
    with TMsgViewDlg.Create(Self) do
    try
      MailMessage:=msArticle1;
      ShowModal;
    finally
      Free;
    end;
  end
  else
    MessageDlg('Please highlight an article first',
               mtError,[mbOk],0);
end;

procedure TNNTPForm.CancelButtonClick(Sender: TObject);
begin
  msNNTP.Cancel;
end;

procedure TNNTPForm.msNNTPPosting(Sender: TObject);
begin
  Sb1.Caption:='Posting article...';
end;

procedure TNNTPForm.msNNTPLastHeaderRetrieved(Sender: TObject);
begin
  Sb1.Caption:='Last header retrieved';
end;

end.
